use "istat_ind0511.dta", clear

drop rgdp tfr er ur dgdp
merge m:1 reg pe030 using "reg_year77new.dta" 
drop if _merge==2
drop _merge
rename dgdp_one_year dgdp
compress

cap drop date_birth
gen date_birth = yq(rb080, rb070)
label variable date_birth "Date of birth in quarters (since 1960q1)"

replace pb100=4 if pb100==.
cap drop date_int
gen date_int = yq(pb110, pb100)
label variable date_int "Date of interview in quarters (since 1960q1)"

cap drop date_edu
gen date_edu = yq(pe030, 2)
label variable date_edu "Date of highest education in quarters (since 1960q1)"

*******************	HERE MODIFICATION TO ANTICIPATE 3 MONTHS STARTS*************
forvalues k = 1 (1) 3 {
cap drop date_child`k'
gen date_child`k' = yq(child_ybirth`k', child_qbirth`k')-3
label variable date_child`k' "Date of birth of child `k' in quarters (since 1960q1)"
}

forvalues k = 1 (1) 3 {
cap drop child_ybirth_9m`k'
gen     child_ybirth_9m`k'=child_ybirth`k'   if child_qbirth`k'<=4 & child_qbirth`k'>=2
replace child_ybirth_9m`k'=child_ybirth`k'-1 if child_qbirth`k'==1
}
********************************************************************************
gen cens1=0
replace cens1=1 if date_child1==.
label variable cens1 "Censoring indicator: 1 if the woman without kids"

gen cens2=0
replace cens2=1 if date_child2==.
label variable cens2 "Censoring indicator: 1 if the woman does not have 2 kids"

gen cens3=0
replace cens3=1 if date_child3==.
label variable cens3 "Censoring indicator: 1 if the woman does not have 3 kids"

forvalues k = 1 (1) 3 {
cap drop dur`k'
gen dur`k'=date_child`k'-date_edu
replace dur`k'=date_int-date_edu if dur`k'==.
label variable dur`k' "Duration in quarters between education and kid `k'"
}

forvalues k = 1 (1) 3 {
cap drop ageq_birth`k'
gen ageq_birth`k'=date_child`k'-date_birth
replace ageq_birth`k'=date_int-date_birth if ageq_birth`k'==.
label variable ageq_birth`k' "Age in quarters at birth of kid `k'"
}

cap drop spacing1
gen spacing1=dur1
label variable spacing1 "Duration in quarters between education and kid 1 (interview date for no kids)"
tab spacing1 if nkids>=1

cap drop spacing2
gen spacing2=date_child2-date_child1 if nkids>=2
replace spacing2=date_int-date_child1 if nkids==1
label variable spacing2 "Duration in quarters between kid 2 and kid 1 (interview date for only 1 kid, missing otherwise)"
tab spacing2 if nkids>=2

cap drop spacing3
gen spacing3=date_child3-date_child2 if nkids==3
replace spacing3=date_int-date_child2 if nkids==2
label variable spacing3 "Duration in quarters between kid 3 and kid 2 (interview date for 2 kids, missing otherwise)"
tab spacing3 if nkids>=3

*********************************************************************************************
*LIVED WITH BOTH PARENTS WHEN 14 YEARS OLD
*********************************************************************************************
cap drop livepar
generate livepar=0
replace  livepar=1 if (pm010==1 & anno_silc==2005) | (pt010==1 & anno_silc==2011)
label variable livepar "Lived with both parents when 14 years old"

*********************************************************************************************
*NUMBER OF CHILDREN IN THE HOUSEHOLD WHEN 14 YEARS OLD
*********************************************************************************************
cap drop nsib
generate nsib=pm035   if anno_silc==2005
replace  nsib=pt030-1 if anno_silc==2011
cap drop d11
gen d11=0
replace d11=1 if anno_silc==2011
gen nsib_d11=nsib*d11
label variable nsib_d11 "Presence of kids<18 years in the household old when 14 years old"
cap drop d05
gen d05=0
replace d05=1 if anno_silc==2005
gen nsib_d05=nsib*d05
label variable nsib_d05 "Presence of siblings in the household when 14 years old"
drop if nsib==.

*********************************************************************************************
*AGE OF FATHER/MOTHER WHEN THE INDIVIDUAL WAS BORN
*********************************************************************************************
cap drop ybfath
gen ybfath=0
replace ybfath=pm020 if anno_silc==2005 & pm020_f==1
replace ybfath=pt050 if anno_silc==2011 & pt050_f==1
cap drop ybfath_miss
gen ybfath_miss=0
replace ybfath_miss=1 if ybfath==0
label variable ybfath "Year of birth of the father"
label variable ybfath_miss "Year of birth of the father si missing"
cap drop agedfa
gen agedfa=0
replace agedfa=rb080-ybfath if ybfath_miss==0
label variable agedfa "Age of father when the individual was born"

cap drop ybmoth
gen ybmoth=0
replace ybmoth=pm030 if anno_silc==2005 & pm030_f==1
replace ybmoth=pt080 if anno_silc==2011 & pt080_f==1
cap drop ybmoth_miss
gen ybmoth_miss=0
replace ybmoth_miss=1 if ybmoth==0
label variable ybmoth "Year of birth of the mother"
label variable ybmoth_miss "Year of birth of the mother si missing"
cap drop agedmo
gen agedmo=0
replace agedmo=rb080-ybmoth if ybmoth_miss==0
label variable agedmo "Age of mother when the individual was born"

*drop women with strange date of birth of their parents
drop if (agedmo<13 & ybmoth_miss==0) | (agedmo>52 & ybmoth_miss==0) | (agedfa<13 & ybfath_miss==0)

*********************************************************************************************
*EDUCATION OF FATHER/MOTHER
*********************************************************************************************
cap drop fedu
gen fedu=pt110 if anno_silc==2011
replace fedu=1 if fedu==0
replace fedu=1 if anno_silc==2005 & (pm040==0 | pm040==1)
replace fedu=2 if anno_silc==2005 & (pm040==2 | pm040==3 | pm040==4)
replace fedu=3 if anno_silc==2005 & pm040==5
replace fedu=0 if fedu==.
label variable fedu "Father's education"
label define edup 0 "Missing" 1 "Nothing or primary" 2 "Secondary and post-secondary non-tertiary" 3 "Tertiary"
label values fedu edup

cap drop medu
gen medu=pt120 if anno_silc==2011
replace medu=1 if medu==0
replace medu=1 if anno_silc==2005 & (pm050==0 | pm050==1)
replace medu=2 if anno_silc==2005 & (pm050==2 | pm050==3 | pm050==4)
replace medu=3 if anno_silc==2005 & pm050==5
replace medu=0 if medu==.
label variable medu "Mother's education"
label values medu edup

tab fedu, gen(fedu)
tab medu, gen(medu)
*********************************************************************************************
*EMPLOYMENT STATUS OF FATHER/MOTHER
*********************************************************************************************
cap drop femp
gen femp=0
replace femp=1 if (pt130==1 | pt130==2) & anno_silc==2011
replace femp=1 if (pm060==1 | pm060==2) & anno_silc==2005
label variable femp "Employment status of father"

cap drop memp
gen memp=0
replace memp=1 if (pt160==1 | pt160==2) & anno_silc==2011
replace memp=1 if (pm080==1 | pm080==2) & anno_silc==2005
label variable memp "Employment status of mother"

cap drop m_femp
gen m_femp=memp*femp
label variable m_femp "=1 if both parents are employed"

*********************************************************************************************
*Quarter of birth
*********************************************************************************************
tab rb070, gen(qbir)
****************************************************************************
*Education from pe040 ISCED codes
****************************************************************************
gen edu1=0
replace edu1=1 if pe040==0 | pe040==1 | pe040==2 | pe040_f==-2
gen edu2=0
replace edu2=1 if pe040==3
gen edu3=0
replace edu3=1 if pe040==4 | pe040==5

label variable edu1 "Education: None, elementary, or lower secondary"
label variable edu2 "Education: Upper secondary"
label variable edu3 "Education: Post secondary or tertiary"
*********************************************************************************************
*Year of birth
*********************************************************************************************
sum rb080
cap drop ybirth
gen ybirth=rb080-r(min)
cap drop ybirthsq
gen ybirthsq=ybirth^2/100

gen y60=0
replace y60=1 if rb080<1970
gen y70=0
replace y70=1 if rb080>=1970 & rb080<1980
gen y80=0
replace y80=1 if rb080>=1980 & rb080<1990

*********************************************************************************************
*Minutes to finish the interview
*********************************************************************************************
cap drop mint
gen mint=pb120
label variable mint "Minutes to finish the interview (0 for missing observations)"
replace mint=0 if mint==.
cap drop mmint
gen mmint=0
replace mmint=1 if pb120==.
label variable mmint "=1 if minutes to finish the intervie wis missing"
*********************************************************************************************
*Regions
*********************************************************************************************
tab reg, gen(reg)
*********************************************************************************************
*Dummies for age of school exit
*********************************************************************************************
tab aedu, gen(aedu)
*********************************************************************************************
*********************************************************************************************
cap drop dur1_lo
generate dur1_lo = dur1 - 1  	if cens1 == 0
replace  dur1_lo = dur1 - 0.5   if cens1 == 1  
cap drop dur1_up
generate dur1_up = dur1     if cens1 == 0
replace  dur1_up = .        if cens1 == 1

cap drop ageq1_lo
generate ageq1_lo = ageq_birth1 if cens1 == 0
replace  ageq1_lo = ageq_birth1 if cens1 == 1  
cap drop ageq1_up
generate ageq1_up = ageq_birth1 if cens1 == 0
replace  ageq1_up = .           if cens1 == 1

cap drop complete
generate complete=1-cens1

preserve
rename pid id_individuo
keep id_individuo
sort id_individuo
save "sample_itsilc.dta", replace
restore
compress
save "cleaned_itsilc.dta", replace
